import scipy.io
import csv
from itertools import izip
import numpy as np

ifile = "20171112_AXCP_17@Q1.mat"
ofile = "20171112_AXCP_17@Q1.csv"

mat = scipy.io.loadmat(ifile)
T = mat.get("TEMP")[0]
Z = mat.get("DEPTH")[0]
U = mat.get("U")[0]
V = mat.get("V")[0]

a = ["depth (m)"]
b = ["Temp (degC)"]
c = ["Speed (m/s)"]
d = ["Directions (deg)"]
e = ["U (cm/s)"]
f = ["V (cm/s)"]

spd = np.sqrt(U*U + V*V)
direc = np.arctan2(V, U)/np.pi*180


for i in Z:
    a.append(i)

for j in T:
    b.append(j)

for k in U:
    e.append(k)

for l in V:
    f.append(l)

for m in spd:
    c.append(m)

for n in direc:
    d.append(n)



Data = zip(a,b)

with open(ofile, 'wb') as x:
    writer = csv.writer(x)
    writer.writerows(izip(a, b, c, d, e, f))
    
